//	CDialogFormatDisk.c

#ifndef _H_CDialogFormatDisk
#define _H_CDialogFormatDisk

#include "CDialog.h"
#include "FileSystemTypes.h"

enum {
	kFormat_NONE, 
	
	kFormat_CANCEL,
	kFormat_FORMAT, 
	kFormat_OS_POP, 
	kFormat_VERBAGE,
	
	kFormat_NUMTYPES
};

enum {
	kFormat_ItemStr_VERB,
	kFormat_ItemStr_NUMTYPES
};
typedef short	DlgFormat_ItemStrType;

/***************************************/

OSErr		DoFormatDiskDialog(PhysVolumeRec *volRecP);

class CDialogFormatDisk : public CDialog {

	public:		Boolean		IDialogFormatDisk(void);
	virtual		void		Dispose(void);
	
	virtual		void		DoClick(EventRecord *event);
	virtual		void		DoKeyDown(EventRecord *event);
	virtual		void		Move(EventRecord *event);
	
	virtual		void		DialogItemStandardDrawProc(
		DialogItemIndex	itemNo,
		Rect			*itemRectP);

	void		ValueConvert(
		DGI_ValueConvertType	convertType, 
		short					dlgItem);
	
	/******************************************/
	DGI_ItemRec		i_itemStrTable[kFormat_ItemStr_NUMTYPES];
	
	FSType			i_formatType;
	Dlog_ItemIDType	i_buttonPressed;

	typedef		 	CDialog		_inherited;
};

#endif